function [] = syn_collate()
%This function works on an output data directory structure and generates a
%simplified experiment directory structure (collated_data), which is then
%used by join_verts and maybe join_sum.  For the expected structure of the
%input directory structure look at the syn_collate-directory.dia.
%Synatax:   [data] = syn_collate();
%Input:     you will be prompted to point to the root of the directory
%               structure.
%Output:    data = dataset of filenames and directory names

%initialize
outsources = {};
outindexes = {};
out_table = {};

dir_root = uigetdir2('','Directory where the files are located');    %get the directory

dir_lv1 = dir(dir_root);    %get the file structure of the root dir.
out_root = [dir_root,filesep,['collated',datestr(now,'yyyymmdd.HHMM')],filesep];   %make the output directory structure root
mkdir(out_root);         %create the output root.

%now lets crank through the directories
for i = 3:size(dir_lv1,1)   %level 1: always start on 3 as 1 and 2 are . and .. (Dir: 20110308...etc.)
    if dir_lv1(i).isdir     %if this is a directory continue; else case...who cares
        dir_lv2 = dir([dir_root,filesep,dir_lv1(i).name]);  %now get the directory structure of the next level
        dir_tmp = [dir_root,filesep,dir_lv1(i).name,filesep]; %the current level 2 directory 
        if dir_end(dir_lv2)     %Test if this is the end level
            %Get here later
            error('There is a strict directory structure, and this is not it.');    %did not mean to use a strict directory structure
            %But storing an x possible drill down directory structure in a
            %n possible cell array, turns out to be too unwieldy.  Look at
            %the stored ver0.2 if you want to resurrect this, but for now
            %we are deadlocking this.  Check dir_struct.dia for the proper
            %directory structure.
        else    %not the end yet(expected)
            for j = 3:size(dir_lv2,1)   %level 2: Care about the name of this level (Dir: WT, KO, etc.)
                if dir_lv2(j).isdir     %if is a directory continue; else case not important.
                    dir_lv3 = dir([dir_tmp,dir_lv2(j).name]);   %get the third level
                    dir_tmp2 = [dir_tmp,dir_lv2(j).name,filesep];  %the current level3 directory
                    if dir_end(dir_lv3)
                        %Come back for this later
                        error('There is a strict directory structure, and this is not it.');
                    else    %no the end yet(expected)
                        for k = 3:size(dir_lv3,1)   %level 3: The care about level (Dir: Layer23, Layer4, etc.)
                            if dir_lv3(k).isdir     %go forth; we don't care about files
                                dir_lv4 = dir([dir_tmp2,dir_lv3(k).name]);   %get the fourth level
                                dir_tmp3 = [dir_tmp2,dir_lv3(k).name,filesep];  %the current level 4 directory
                                if dir_end(dir_lv4)
                                    error(['There is a strict directory structure, and this is not it.',dir_tmp3]);
                                else
                                    for l = 3:size(dir_lv4,1)   %level4: Men's Wear (Dir: R1, R2, etc.)
                                        if dir_lv4(l).isdir
                                            dir_lv5 = dir([dir_tmp3,dir_lv4(l).name]);  %get the fifth level
                                            dir_tmp4 = [dir_tmp3,dir_lv4(l).name,filesep]; %The current level 5 directory
                                            if dir_end(dir_lv5) 
                                                error('There is a strict directory structure, and this is not it.');
                                            else
                                                for m = 3:size(dir_lv5,1)   %level5: One more to go (Dir: VGluT1, VGluT2, etc.)
                                                    if dir_lv5(m).isdir
                                                        dir_lv6 = dir([dir_tmp4,dir_lv5(m).name]);   %The end level
                                                        dir_tmp5 = [dir_tmp4,dir_lv5(m).name,filesep];
                                                        %we only care about the files now.
                                                        if size(dir_lv6,1)>2    %no empty directories
                                                            [flat,prop,aflat,aprop,count,acount,aucount,rotated,avert,vert] = process_files(dir_lv6);     %get the files we want to move
                                                            %now setup the out put directory structure
                                                            warning 'off'   %set it off so no annoying chirps for creating a directory
                                                            mkdir(out_root,dir_lv5(m).name);    %create the root folder for this syn class
                                                            mkdir([out_root,dir_lv5(m).name,filesep],dir_lv2(j).name);    %KO
                                                            mkdir([out_root,dir_lv5(m).name,filesep,dir_lv2(j).name,filesep],dir_lv3(k).name);  %layer4
                                                            %create out dir tmp
                                                            if ~isempty(flat)
                                                                out_flat = [out_root,dir_lv5(m).name,filesep,dir_lv2(j).name,filesep,dir_lv3(k).name,filesep,'flat',filesep];
                                                                mkdir(out_flat);
                                                                for n = 1:size(flat,2) %go through files and copy them to new destinations
                                                                    copyfile([dir_tmp5,flat{n}],[out_flat,padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4),'_',flat{n}]);
                                                                end
                                                            end
                                                            if ~isempty(prop)
                                                                out_prop = [out_root,dir_lv5(m).name,filesep,dir_lv2(j).name,filesep,dir_lv3(k).name,filesep,'prop',filesep];
                                                                mkdir(out_prop);
                                                                for o = 1:size(prop,2) %no copy over the properties files
                                                                    copyfile([dir_tmp5,prop{o}],[out_prop,padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4),'_',prop{o}]);
                                                                end
                                                            end
                                                            if ~isempty(aflat)
                                                                out_aflat = [out_root,dir_lv5(m).name,filesep,dir_lv2(j).name,filesep,dir_lv3(k).name,filesep,'aflat',filesep];
                                                                mkdir(out_aflat);
                                                                for n = 1:size(aflat,2) %go through files and copy them to new destinations
                                                                    copyfile([dir_tmp5,aflat{n}],[out_aflat,padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4),'_',aflat{n}]);
                                                                end
                                                            end
                                                            if ~isempty(aprop)
                                                                out_aprop = [out_root,dir_lv5(m).name,filesep,dir_lv2(j).name,filesep,dir_lv3(k).name,filesep,'aprop',filesep];
                                                                mkdir(out_aprop);
                                                                for o = 1:size(aprop,2) %no copy over the properties files
                                                                    copyfile([dir_tmp5,aprop{o}],[out_aprop,padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4),'_',aprop{o}]);
                                                                end
                                                            end
                                                            if ~isempty(count)
                                                                out_count = [out_root,dir_lv5(m).name,filesep,dir_lv2(j).name,filesep,dir_lv3(k).name,filesep,'count',filesep];
                                                                mkdir(out_count);
                                                                for n = 1:size(count,2) %go through files and copy them to new destinations
                                                                    copyfile([dir_tmp5,count{n}],[out_count,padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4),'_',count{n}]);
                                                                end
                                                            end
                                                            if ~isempty(acount)
                                                                out_acount = [out_root,dir_lv5(m).name,filesep,dir_lv2(j).name,filesep,dir_lv3(k).name,filesep,'allcount',filesep];
                                                                mkdir(out_acount);
                                                                for o = 1:size(acount,2) %no copy over the properties files
                                                                    copyfile([dir_tmp5,acount{o}],[out_acount,padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4),'_',acount{o}]);
                                                                end
                                                            end
                                                            if ~isempty(aucount)
                                                                out_aucount = [out_root,dir_lv5(m).name,filesep,dir_lv2(j).name,filesep,dir_lv3(k).name,filesep,'alluniquecount',filesep];
                                                                mkdir(out_aucount);
                                                                for n = 1:size(aucount,2) %go through files and copy them to new destinations
                                                                    copyfile([dir_tmp5,aucount{n}],[out_aucount,padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4),'_',aucount{n}]);
                                                                end
                                                            end
                                                            if ~isempty(rotated)
                                                                out_rotated = [out_root,dir_lv5(m).name,filesep,dir_lv2(j).name,filesep,dir_lv3(k).name,filesep,'rotated',filesep];
                                                                mkdir(out_rotated);
                                                                for o = 1:size(rotated,2) %no copy over the properties files
                                                                    copyfile([dir_tmp5,rotated{o}],[out_rotated,padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4),'_',rotated{o}]);
                                                                end
                                                            end
                                                            if ~isempty(avert)
                                                                out_avert = [out_root,dir_lv5(m).name,filesep,dir_lv2(j).name,filesep,dir_lv3(k).name,filesep,'avert',filesep];
                                                                mkdir(out_avert);
                                                                for n = 1:size(avert,2) %go through files and copy them to new destinations
                                                                    copyfile([dir_tmp5,avert{n}],[out_avert,padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4),'_',avert{n}]);
                                                                end
                                                            end
                                                            if ~isempty(vert)
                                                                out_vert = [out_root,dir_lv5(m).name,filesep,dir_lv2(j).name,filesep,dir_lv3(k).name,filesep,'vert',filesep];
                                                                mkdir(out_vert);
                                                                for o = 1:size(vert,2) %no copy over the properties files
                                                                    copyfile([dir_tmp5,vert{o}],[out_vert,padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4),'_',vert{o}]);
                                                                end
                                                            end
                                                            outsources = vertcat(outsources,dir_tmp5);  %where the data is coming from
                                                            outindexes = vertcat(outindexes,{padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4)}); %what number we gave to data from this set
                                                            warning 'on'    %back on
                                                        end
                                                        %create a look up table for output
                                                        %index and the date, condition, layer,
                                                        %region...
                                                        out_table = vertcat(out_table,{dir_lv1(i).name,dir_lv2(j).name,dir_lv3(k).name,dir_lv4(l).name,dir_lv5(m).name,padnum([num2str(i-2),num2str(j-2),num2str(l-2)],4)});
                                                    end
                                                end
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end
outdata = dataset(outindexes,'ObsNames',outsources,'VarNames',{'index'});
sav2csv(outdata,'output_summary.csv',out_root);       
sav2csv(out_table,'output_lookup.csv',out_root);
        
%--------------------------------------------------------------------------
%sub function to figure out if this level is only files, meaning this is
%the end dir.
function [is_end] = dir_end(dir_struct)

is_end = 0;  %initiate

for i = 3:size(dir_struct,1)    %go through the 
    is_end(i-2)=dir_struct(i).isdir;     %pull the isdir info
end

is_end = logical(1-max(is_end));       %readout of whether this directory has only files.

%--------------------------------------------------------------------------
%subfunction to seperate files from directories
function [flat,prop,aflat,aprop,count,acount,aucount,rotated,avert,vert] = process_files(dir_info)

curr_names = {dir_info.name};   %grab the all of the names
idx = [dir_info.isdir];   %grab all of the isdir numbers
filenames = curr_names(~idx);   %grab the files first
filenames = findfiletype(filenames,'.csv');  %only csvs

%filter for only the files we want
flat_idx = ones(size(filenames));   %create an index for selecting the flat files
prop_idx = ones(size(filenames));   %same for prop
aflat_idx = ones(size(filenames));   %create an index for selecting the flat files
aprop_idx = ones(size(filenames));   %same for prop
count_idx = ones(size(filenames));   %create an index for selecting the flat files
acount_idx = ones(size(filenames));   %same for prop
aucount_idx = ones(size(filenames));   %same for prop
rotated_idx = ones(size(filenames));   %same for prop
avert_idx = ones(size(filenames));   %vertices
vert_idx = ones(size(filenames));   %same 
for j = 1:size(filenames,2);
    %the only files we care about are the flat rotated vertices and the properties for now
    if ~strcmp('flat',filenames{j}(1:4))
        flat_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('prop',filenames{j}(1:4))
        prop_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('aflat',filenames{j}(1:5))
        aflat_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('aprop',filenames{j}(1:5))
        aprop_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('count',filenames{j}(1:5))
        count_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('allco',filenames{j}(1:5)) %allcount
        acount_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('allun',filenames{j}(1:5))  %alluniquecount
        aucount_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('rotat',filenames{j}(1:5))  %rotated
        rotated_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('avert',filenames{j}(1:5))  %alluniquecount
        avert_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('vert',filenames{j}(1:4))  %rotated
        vert_idx(j) = 0;    %set this for removal
    end
end
%create the desired lists of file names.
flat = filenames(logical(flat_idx));    %list for flat vertices files
prop = filenames(logical(prop_idx));    %list for prop files
aflat = filenames(logical(aflat_idx));    %list for flat vertices files
aprop = filenames(logical(aprop_idx));    %list for prop filesflat = list(logical(flat_idx));    %list for flat vertices files
count = filenames(logical(count_idx));    %list for flat vertices files
acount = filenames(logical(acount_idx));    %list for prop filesflat = list(logical(flat_idx));    %list for flat vertices files
aucount = filenames(logical(aucount_idx));    %list for flat vertices files
rotated = filenames(logical(rotated_idx));    %list for prop filesflat = list(logical(flat_idx));    %list for flat vertices files
avert = filenames(logical(avert_idx));    %list for vertices files
vert = filenames(logical(vert_idx));    %vertices files


% flat(logical(flat_idx)) = [];   %remove
% prop(logical(prop_idx)) = [];   %gone